<?php
include 'conexion.php';

// Obtener los datos del POST
$user = $_POST['user'];
$horario = $_POST['horario'];
$points = explode(",", $_POST['points']); // IDs de los puntos seleccionados separados por comas

// Obtener el ID del usuario
$queryUsuario = "SELECT id FROM usuarios WHERE user = '$user'";
$resultUsuario = mysqli_query($conexion, $queryUsuario);
$rowUsuario = mysqli_fetch_assoc($resultUsuario);
$usuario_id = $rowUsuario['id'];

// Calcular el precio total
$totalPrecio = 0;

// Obtener los precios de los puntos seleccionados
foreach ($points as $point_id) {
    $queryPrecio = "SELECT precio FROM point_local WHERE id = '$point_id'";
    $resultPrecio = mysqli_query($conexion, $queryPrecio);
    $rowPrecio = mysqli_fetch_assoc($resultPrecio);
    
    // Sumar el precio de cada punto
    if ($rowPrecio) {
        $totalPrecio += floatval($rowPrecio['precio']);
    }
}

// Iniciar transacción
mysqli_begin_transaction($conexion);

try {
    // Insertar el viaje incluyendo el precio total
    $queryViaje = "INSERT INTO viajes (usuario_id, horario, preciototal) VALUES ('$usuario_id', '$horario', '$totalPrecio')";
    if (!mysqli_query($conexion, $queryViaje)) {
        throw new Exception('Error al insertar el viaje: ' . mysqli_error($conexion));
    }
    
    // Obtener el ID del viaje recién creado
    $viaje_id = mysqli_insert_id($conexion);

    // Insertar los puntos seleccionados en la tabla 'viaje_point_local'
    foreach ($points as $point_id) {
        $queryPoint = "INSERT INTO viaje_point_local (viaje_id, point_local_id) VALUES ('$viaje_id', '$point_id')";
        if (!mysqli_query($conexion, $queryPoint)) {
            throw new Exception('Error al insertar el punto local: ' . mysqli_error($conexion));
        }
    }

    // Confirmar la transacción
    mysqli_commit($conexion);

    // Respuesta de éxito
    echo json_encode(['status' => 'success', 'viaje_id' => $viaje_id]);

} catch (Exception $e) {
    // Si hay un error, revertir la transacción
    mysqli_rollback($conexion);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

mysqli_close($conexion);
?>
