<?php

include 'conexion.php'; // Incluye la conexión a la base de datos

// Crear el array de respuesta
$response = array();

try {
    // Consulta SQL para obtener todos los puntos locales
    $sql = "SELECT id, nombre, ubicacion, coordenadas, precio, descripcion, imgrt FROM point_locales";

    // Ejecutar la consulta
    $result = $conexion->query($sql);

    // Verificar si hay resultados
    if ($result->num_rows > 0) {
        // Recorrer todas las filas
        while ($row = $result->fetch_assoc()) {
            // Añadir cada fila al array de respuesta
            $response[] = $row;
        }
    } else {
        // Si no hay resultados, agregar un mensaje de error
        $response['error'] = true;
        $response['message'] = 'No se encontraron puntos locales';
    }

    // Cerrar la conexión
    $conexion->close();

} catch (Exception $e) {
    // Manejo de errores
    $response['error'] = true;
    $response['message'] = 'Error en la consulta: ' . $e->getMessage();
}

// Devolver la respuesta en formato JSON
header('Content-Type: application/json'); // Establecer el encabezado de tipo de contenido
echo json_encode($response); // Devolver la respuesta en JSON
?>
