<?php
include 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtener parámetros
    $user = $_POST['user'];

    // Preparar la consulta SQL para obtener todos los datos del usuario
    $stmt = $conexion->prepare("SELECT * FROM usuarios WHERE user = ?");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Obtener los datos del usuario
        $row = $result->fetch_assoc();
        // Eliminar la contraseña del array
        unset($row['pass']);
        echo json_encode($row); // Devuelve los datos del usuario como JSON
    } else {
        echo json_encode(["error" => "Usuario no encontrado"]);
    }

    $stmt->close();
    $conexion->close();
}
?>
