<?php
// Incluir el archivo de conexión
include 'conexion.php';

// Verificar si se recibe el parámetro 'user'
if (isset($_GET['user'])) {
    $user = $_GET['user'];

    // Preparar la consulta para obtener el ID del usuario basado en su nombre de usuario
    $consultaUsuario = $conexion->prepare("SELECT id FROM usuarios WHERE user = ?");
    $consultaUsuario->bind_param('s', $user);
    $consultaUsuario->execute();
    $resultadoUsuario = $consultaUsuario->get_result();

    // Verificar si se encontró el usuario
    if ($resultadoUsuario->num_rows > 0) {
        $usuario = $resultadoUsuario->fetch_assoc();
        $usuario_id = $usuario['id'];

        // Ahora que tenemos el ID del usuario, obtenemos los viajes correspondientes
        $consultaViajes = $conexion->prepare("SELECT horario, preciototal FROM viajes WHERE usuario_id = ?");
        $consultaViajes->bind_param('i', $usuario_id);
        $consultaViajes->execute();
        $resultadoViajes = $consultaViajes->get_result();

        // Verificar si hay resultados
        if ($resultadoViajes->num_rows > 0) {
            $viajes = array();

            // Recorrer los resultados y agregarlos al array
            while ($row = $resultadoViajes->fetch_assoc()) {
                $viajes[] = $row;
            }

            // Devolver los datos en formato JSON
            echo json_encode($viajes);
        } else {
            // Si no hay resultados, devolver un array vacío
            echo json_encode([]);
        }

        // Cerrar la consulta de viajes
        $consultaViajes->close();
    } else {
        echo json_encode(["error" => "Usuario no encontrado."]);
    }

    // Cerrar la consulta de usuario
    $consultaUsuario->close();
    $conexion->close();
} else {
    echo json_encode(["error" => "No se proporcionó un usuario."]);
}
?>
